﻿var editSystemModule = {
    context: GetContext(),
    projectId: $("#ProjectId").val(),
    moduleId: $("#ModuleId").val(),
    ProntoNo: $("#ProntoNo").val() === "" ? "0" : $("#ProntoNo").val(),
    ProntoModuleType: $("#ProntoModuleType").val(),
    Type: $("#Type").val(),
    initialize: function () {
        $(".v-moduleEditorTabs", this.context).a4tabs({
            defaultTab: $("#activeTab").attr("tab"),
            load: function (e, d) {
                if (d.id == "users") {
                    var usersOrGroups = $("#UsersOrGroups", editSystemModule.context).val();

                    if (usersOrGroups)
                        editSystemModule.selectedUsersAndGroups = _.map(usersOrGroups.split(","), Number);

                    editSystemModule.initializeTreeView(d.tab);
                }
            }
        });

        $(".h-prontoServers-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetProntoServersForAutoComplete", "MultiMode"),
            ajaxParams: { type: 0 },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#ProntoNo"),
            select: function (event, data) {
                editSystemModule.ProntoNo = data.item === undefined ? "0" : data.item.Id;

                var associatedProjects = $(".h-associatedProjects-autocomplete", editSystemModule.context);

                if (associatedProjects)
                    associatedProjects.a4autocomplete("clearValue");

                associatedProjects.a4autocomplete({
                    ajaxParams: { prontoId: editSystemModule.ProntoNo }
                });

                var monitoringModules = $(".h-MonitoringModules-autocomplete", editSystemModule.context);
                if (monitoringModules)
                    monitoringModules.a4autocomplete("clearValue");

                monitoringModules.a4autocomplete({
                    ajaxParams: { prontoId: editSystemModule.ProntoNo }
                });
                
                editSystemModule.setInputsAvailability();

                var content = $("#LineGroupsEditorContainer");

                a4.callServerMethod(a4.getAction("GetLineAssignment", "MultiMode", "Settings"),
                    {
                        moduleId: $("#Id").val(),
                        prontoId: editSystemModule.ProntoNo,
                        prontoModuleType: editSystemModule.ProntoModuleType,
                        moduleType: editSystemModule.Type
                    },
                    function (result) {
                        content.html(result);
                    },
                    function () {
                        a4.showErrorMessage($(".unexpectedError").html());
                    }
                );
            }
        });

        $(".h-phoneTemplate-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetPhoneTemplates", "MultiMode", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            defaultValue: 0,
            defaultValueWhenInvalid: true,
            altValueField: $("#PhoneTemplateId")
        });

        $(".h-AdvancedTransferLine-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetAdvancedTransferLinesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: { moduleId: editSystemModule.moduleId, prontoId: editSystemModule.ProntoNo },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#AdvancedTransferLine")
        });

        $(".h-MonitoringModules-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetMonitoringModulesForAutoComplete", "MultiMode"),
            ajaxParams: { prontoId: editSystemModule.ProntoNo },
            valueProperty: "Id",
            labelProperty: "Name",
            multipleSelection: true,
            //displayMultipleSelectionAsList: true,
            altValueField: $("#ProjectsToMonitorJson")
        });        

        $(".h-associatedProjects-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetAssociatedProjectsForAutoComplete", "MultiMode", "settings"),
            ajaxParams: { prontoId: editSystemModule.ProntoNo },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#ProntoBlendModel_AssociatedProjectId")
        });

        if ($("#ProntoBlendModel_AutomaticCallBlending", this.context).length > 0) {
            $("#ProntoBlendModel_AutomaticCallBlending", this.context).on("click", function () {
                AutomaticCallBlendingCheck();
            });
            AutomaticCallBlendingCheck();
        }

        if ($("#SecureAccess", this.context).length > 0) {
            $("#SecureAccess", this.context).on("click", function () {
                SecureAccessCheck();
            });
            SecureAccessCheck();
        }

        $(".h-remoteagent-lineassignment", this.context).on("change", ".lineGroupAutoDial", function () {
            outBoundCheckedCount();
        });

        $(".h-remoteagent-lineassignment", this.context).on("change", ".lineGroupInbound", function () {
            inBoundCheckedCount();
        });

        if ($(".h-remoteagent-lineassignment", this.context).length > 0) {
            outBoundCheckedCount();
            inBoundCheckedCount();
        }

        if (GetContextType() == 7) {
            CreateAdvancedLineAssignmentGrid();

            $("#Advanced", this.context).on("click", function () {
                AdvancedCheck();
            });

            inBoundCheckedCount();
            outBoundCheckedCount();
            AdvancedCheck();
        }

        a4.initializeInputs(this.context);
        editSystemModule.setInputsAvailability();

        this.bindEvents();
    },
    bindEvents: function () {
        this.context.on("click", "#submit1", function () {
            // remove not used assignment lines
            var isEnabledAdvancedProps = $("#Advanced", this.context).is(':checked');
            var dynamicEditor = $(".v-dynamicEditor", this.context);

            if (dynamicEditor.length > 0)
            {
                $(".v-assignmentRow", dynamicEditor).each(function () {
                    var row = $(this);
                    var doRemoveRow = false;

                    if (isEnabledAdvancedProps)
                        doRemoveRow = ($(".h-advancedTransferLine", row).val().trim() == "" && $(".v-advancedPhonNumber", row).val().trim() == "");
                    else
                        doRemoveRow = ($(".h-advancedTransferLine", row).val().trim() == "" || $(".v-advancedPhonNumber", row).val().trim() == "");

                    if (doRemoveRow) {
                        replaceItemIndexes(row, dynamicEditor);
                        row.remove();
                    }
                });
            }
        });
    },
    selectedUsersAndGroups: [],
    isGroupActionVisible: function (groupId, users, action) {
        var groupIsSelected = _.contains(editSystemModule.selectedUsersAndGroups, groupId);
        var usersAreSelected = !groupIsSelected && _.some(editSystemModule.selectedUsersAndGroups, function (g) { return _.some(users, function (u) { return u.ExternalId == g }); });
        var visible = false;

        if (action == "unchecked")
            visible = !groupIsSelected && !usersAreSelected;
        else if (action == "checked")
            visible = groupIsSelected;
        else if (action == "partial")
            visible = usersAreSelected;

        return visible;
    },
    setInputsAvailability: function () {
        if (editSystemModule.ProntoNo === "" || editSystemModule.ProntoNo === "0")
        {
            $(".h-associatedProjects-autocomplete", this.context).a4autocomplete("disable");
            $(".h-MonitoringModules-autocomplete", this.context).a4autocomplete("disable");
            $("#ProntoBlendModel_AutomaticCallBlending", this.context).attr("checked", false).prop("checked", false);
        }
        else
        {
            $(".h-MonitoringModules-autocomplete", this.context).a4autocomplete("enable");

            if ($("#ProntoBlendModel_AutomaticCallBlending", this.context).is(':checked') === true)
                $(".h-associatedProjects-autocomplete", this.context).a4autocomplete("enable");           
        }
    },
    updateUsersOrGroupsInput: function() {
        $("#UsersOrGroups", editSystemModule.context).val(editSystemModule.selectedUsersAndGroups.join(","));
    },
    initializeTreeView: function (tab) {
        editSystemModule.userGroupsListView = $(".h-userGroups", tab).a4listview({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings"),
            draw: function (event, data) {
                var group = data.selectedNode;
                var groupId = group ? group.Id : null;

                if (editSystemModule.usersDatatable) {
                    editSystemModule.usersDatatable.a4datatable("option", "ajaxParams", { "groupId": groupId });
                    editSystemModule.usersDatatable.a4datatable("refresh");
                }
                else {
                    editSystemModule.initializeUsersDataTable(tab, groupId);
                }
            },
            actionButtons: [
                {
                    Action: "select", Label: resources.Select, Icon: "checkbox-unchecked",
                    DisplayCondition: function (data) {
                        return data.ExternalId && editSystemModule.isGroupActionVisible(data.ExternalId, data.Users, 'unchecked');
                    }
                },
                {
                    Action: "select", Label: resources.Select, Icon: "checkbox-partial",
                    DisplayCondition: function (data) {
                        return data.ExternalId && editSystemModule.isGroupActionVisible(data.ExternalId, data.Users, 'partial');
                    }
                },
                {
                    Action: "unselect", Label: resources.Unselect, Icon: "checkbox-checked",
                    DisplayCondition: function (data) {
                        return data.ExternalId && editSystemModule.isGroupActionVisible(data.ExternalId, data.Users, 'checked');
                    }
                }
            ],
            actionButtonClick: function (event, data) {
                switch (data.action) {
                    case "select":
                        editSystemModule.selectedUsersAndGroups.push(data.node.ExternalId);
                        break;
                    case "unselect":
                        editSystemModule.selectedUsersAndGroups = _.without(editSystemModule.selectedUsersAndGroups, data.node.ExternalId);
                        break;
                }

                $(this).a4listview("evaluateActionsConditions", data.node.ListView_Internal_Key);

                editSystemModule.updateUsersOrGroupsInput();
            },
            displayActionButtonsOnLeft: true,
            displayActionButtonsOnHover: false,
            icons: null,
            highlightFirstNode: true,
            selectNode: function (event, data) {
                if (!data.selected)
                    return;

                var tableParams = {
                    groupId: data.node ? data.node.Id : null,
                    unassigned: null
                };

                editSystemModule.usersDatatable.a4datatable("option", "ajaxParams", tableParams);
                editSystemModule.usersDatatable.a4datatable("refresh", true);
            },
            localizableTexts: { "Search": resources.SearchUserGroups }
        });
    },
    initializeUsersDataTable: function (tab, groupId) {
        editSystemModule.usersDatatable = $(".h-usersTable", tab).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetUsers", "Users", "Settings"),
            ajaxParams: { "groupId": groupId },
            displayLength: 10,
            allowRowSelection: true,
            displayColumnSelector: false,
            columns: [
                { "Name": "ExternalId", "Visible": false, "Type": "numeric", "Key": true },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName", "Class": "v-name" },
                { "Name": "Firstname", "Title": resources.FirstName, "Data": "Firstname" },
                { "Name": "Lastname", "Title": resources.LastName, "Data": "Lastname" }
            ],
            defaultSorting: "UserName",
            selectedRows: editSystemModule.selectedUsersAndGroups,
            rememberRowSelection: true,
            selectRow: function (e, d) {
                var externalIds = _.pluck(d.data, "ExternalId");

                if (d.isChecked) {
                    editSystemModule.selectedUsersAndGroups = _.union(editSystemModule.selectedUsersAndGroups, externalIds);
                }
                else {
                    editSystemModule.selectedUsersAndGroups = _.difference(editSystemModule.selectedUsersAndGroups, externalIds);
                }

                editSystemModule.userGroupsListView.a4listview("evaluateActionsConditions");

                editSystemModule.updateUsersOrGroupsInput();
            },
            localizableTexts: { "Search": resources.SearchUsers }
        });
    }
};

function GetContextType() {
    if ($(".v-editSystemModule").length > 0) return 5;
    if ($(".v-editSystemModuleAdvanced").length > 0) return 6;
    if ($(".v-editSystemModuleInterviewers").length > 0) return 7;
    if ($(".v-editSytemModuleUsers").length > 0) return 8;
    return $(".v-editSystemModule");
}

function GetContext() {
    if ($(".v-editSystemModule").length > 0) return $(".v-editSystemModule");
    if ($(".v-editSystemModuleAdvanced").length > 0) return $(".v-editSystemModuleAdvanced");
    if ($(".v-editSystemModuleInterviewers").length > 0) return $(".v-editSystemModuleInterviewers");
    if ($(".v-editSytemModuleUsers").length > 0) return $(".v-editSytemModuleUsers");
    return $(".v-editSystemModule");
}

function outBoundCheckedCount() {
    if ($(".lineGroupAutoDial:checked", this.context).length > 0)
    {
        $("#OriginatingPhoneNumber", this.context).removeAttr("disabled").prop("disabled", false);
        $(".h-phoneTemplate-autocomplete", this.context).a4autocomplete("enable");
        $(".v-phoneTemplateSection .title").addClass("required");
    }
    else
    {
        $("#OriginatingPhoneNumber", this.context).attr("checked", true).prop("disabled", true);
        $(".h-phoneTemplate-autocomplete", this.context).a4autocomplete("disable");
        $(".v-phoneTemplateSection .title").removeClass("required");
    }
}

function inBoundCheckedCount() {
    if ($(".lineGroupInbound:checked", this.context).length > 0)
    {
        $("#ProntoRemoteAgentModel_AccessPhoneNumber", this.context).removeAttr("disabled").prop("disabled", false);
        $(".v-accessPhoneNumberSection .title").addClass("required");
    }
    else
    {
        $("#ProntoRemoteAgentModel_AccessPhoneNumber", this.context).attr("checked", true).prop("disabled", true);
        $(".v-accessPhoneNumberSection .title").removeClass("required");
    }
}

function CreateAdvancedLineAssignmentGrid() {
    var dynamicGridsContainer = $(".v-advancedLinesAssignmentDynamicGridEditorContainer", this.context);

    if (dynamicGridsContainer.length > 0)
    {
        $(".v-dynamicEditor", dynamicGridsContainer).each(function () {
            var editor = $(this);

            editor.on("click", ".h-deleteRow", function () {
                var item = $(this).closest(".v-editableItem");
                item.addClass("deleted");
                item.hide();

                $(".v-rowState", item).val(2); // deleted

                replaceItemIndexes(item, editor);

                item.remove();
            });

            editor.on("change", ".h-updateRowState", function () {
                updateItemRowState($(this));
            });

            editor.on("click", ".v-addRow", function () {
                $('.v-dynamicEditorTable', editor).show();

                var rowId = $(".v-dynamicTableBody tr", editor).size() + 1;
                var rowPosition = $(".v-dynamicTableBody tr:visible", editor).size() + 1;

                var newItem = $(".v-newItems .v-newItemBody tr", editor).clone();
                newItem.find(".v-itemIndex").html(rowPosition);
                newItem.find(".v-rowPosition").val(rowPosition);
                newItem.removeClass("row0").addClass("row" + rowId);

                var editorControlName = $(".editorControlName", editor).attr("id");

                $("input, select", newItem).each(function () {
                    $(this).attr("id", editorControlName + "[" + (rowId - 1) + "]" + $(this).attr("id"));
                    $(this).attr("name", editorControlName + "[" + (rowId - 1) + "]." + $(this).attr("name"));
                });

                newItem.find(".h-AdvancedTransferLine-autocomplete").val("");
                newItem.appendTo($("table .v-dynamicTableBody", editor));
                $(".h-autonumeric", newItem).autoNumeric();

                bindAdvancedTransferLineAutoComplete(newItem);

                $(".row" + rowId + " input", editor).bind("keypress", function (e) { return disableEnter(e); });
            });
        });
    }
}

function disableEnter(_e) {
    return (_e.keyCode != 13);
}

function bindAdvancedTransferLineAutoComplete(item) {
    var element = item.find(".h-AdvancedTransferLine-autocomplete") || $(".h-AdvancedTransferLine-autocomplete:visible", this.context);

    element.a4autocomplete({
        ajaxAction: a4.getAction("GetAdvancedTransferLinesForAutoComplete", "MultiMode", "Settings"),
        ajaxParams: { moduleId: editSystemModule.moduleId, prontoId: editSystemModule.ProntoNo },
        valueProperty: "Id",
        labelProperty: "Name",
        altValueField: $("#AdvancedTransferLine", item)
    });
}

function replaceItemIndexes(startItem, gridEditor, increaseStartItem) {
    // Replace order if item deleted
    var previousIndex = $(".v-itemIndex", startItem).html();

    // For cancel of delete
    if (increaseStartItem) {
        previousIndex++;
    }

    startItem.nextAll(".v-editableItem:visible").each(function () {
        var currentRow = $(this);

        $(".v-itemIndex", $(this)).html(previousIndex);
        $(".v-rowPosition", $(this)).val(previousIndex);

        var editorControlName = $(".editorControlName", gridEditor).attr("id");

        $("input, select", currentRow).each(function () {
            var inputName = $(this).attr("name").substr($(this).attr("name").indexOf(".") + 1);

            $(this).attr("id", editorControlName + "_" + (previousIndex - 1) + "__" + inputName);
            $(this).attr("name", editorControlName + "[" + (previousIndex - 1) + "]." + inputName);
        });

        previousIndex++;
    });
}

function updateItemRowState(triggerField) {
    var stateField = $(".v-rowState", triggerField.parents(".v-editableItem"));

    if (stateField.val() == 1)
        stateField.val(3); // updated
}

function AutomaticCallBlendingCheck() {
    if (($("#ProntoBlendModel_AutomaticCallBlending", this.context).is(':checked')) && (editSystemModule.ProntoNo !== "" && editSystemModule.ProntoNo !== "0"))
        $(".h-associatedProjects-autocomplete", this.context).a4autocomplete("enable");
    else
    {
        $(".h-associatedProjects-autocomplete", this.context).a4autocomplete("disable");
        $(".h-associatedProjects-autocomplete", this.context).a4autocomplete("clearValue");
    }
}

function SecureAccessCheck() {
    if ($("#SecureAccess", this.context).is(':checked'))
        $("#ValidateCode", this.context).removeAttr("disabled").prop("disabled", false);
    else
        $("#ValidateCode", this.context).attr("checked", true).prop("disabled", true);

}
function AdvancedCheck() {
    if ($("#Advanced", this.context).is(':checked'))
    {
        $("#UnrestrainedUserDialing", this.context).removeAttr("disabled").prop("disabled", false);
        $("#Conference", this.context).removeAttr("disabled").prop("disabled", false);
        $("#Transfer", this.context).removeAttr("disabled").prop("disabled", false);
        $("#OnHoldSoundFile", this.context).removeAttr("disabled").prop("disabled", false);
    }
    else
    {
        $("#UnrestrainedUserDialing", this.context).attr("checked", true).prop("disabled", true);
        $("#UnrestrainedUserDialing", this.context).attr("checked", false).prop("checked", false);
        $("#Conference", this.context).attr("checked", true).prop("disabled", true);
        $("#Conference", this.context).attr("checked", false).prop("checked", false);
        $("#Transfer", this.context).attr("checked", true).prop("disabled", true);
        $("#Transfer", this.context).attr("checked", false).prop("checked", false);
        $("#OnHoldSoundFile", this.context).attr("checked", true).prop("disabled", true);
        $("#OnHoldSoundFile", this.context).val("");
    }
}

$(document).ready(function () {
    if (editSystemModule.context.length > 0) {
        editSystemModule.initialize();
    }
});